package gov.va.med.mhv.admin.web.validator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.ResourceBundle;
import java.util.regex.Pattern;

import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.context.FacesContext;
import javax.faces.validator.FacesValidator;
import javax.faces.validator.Validator;
import javax.faces.validator.ValidatorException;

@FacesValidator(value = "attendedSearchValidator")
public class AttendedSearchValidator implements Validator {

	@Override
	public void validate(FacesContext context, UIComponent component, Object value) throws ValidatorException {
		System.out.println("AttendedSearchValidator:  validate():  Begin");
		
		ResourceBundle bundle = ResourceBundle.getBundle("labels.messages", FacesContext.getCurrentInstance()
				.getViewRoot().getLocale());
		Collection<FacesMessage> errorMessages = new ArrayList<FacesMessage>();

		UIInput nameOfHCIdMRepValue = (UIInput) component.getAttributes().get("nameOfHCIdMRep");
		System.out.println("AttendedSearchValidator:  nameOfHCIdMRepValue    = " + nameOfHCIdMRepValue.getValue());

		// Per requirements, at least one of the user data entry fields must
		// have a value.
		if (!fieldValueFound(component)) {
			FacesMessage errorMessage = new FacesMessage(FacesMessage.SEVERITY_ERROR,
					bundle.getString("searchmviOneValueRequired"), "");
			errorMessages.add(errorMessage);
		}

		// The 'Name of HCIdM Representative' must have a value.
		String nameOfHCIdMRep = "";
		if (nameOfHCIdMRepValue != null && nameOfHCIdMRepValue.getValue() != null) {
			nameOfHCIdMRep = (String) nameOfHCIdMRepValue.getValue();
		}
		if (nameOfHCIdMRep == null || nameOfHCIdMRep.isEmpty()) {
			FacesMessage errorMessage = new FacesMessage(FacesMessage.SEVERITY_ERROR,
					bundle.getString("searchmviNameOfHCIdMRepRequired"), "");
			errorMessages.add(errorMessage);
		}

		if (errorMessages.size() > 0) {
			throw new ValidatorException(errorMessages);
		}
	}
	
	private boolean fieldValueFound(UIComponent component) {
		UIInput firstNameValue = (UIInput) component.getAttributes().get("firstName");
		UIInput middleNameValue = (UIInput) component.getAttributes().get("middleName");
		UIInput lastNameValue = (UIInput) component.getAttributes().get("lastName");
		UIInput genderValue = (UIInput) component.getAttributes().get("gender");
		UIInput ssnThreeValue = (UIInput) component.getAttributes().get("ssnThree");
		UIInput ssnTwoValue = (UIInput) component.getAttributes().get("ssnTwo");
		UIInput ssnFourValue = (UIInput) component.getAttributes().get("ssnFour");
		UIInput birthDateValue = (UIInput) component.getAttributes().get("birthDate");
		UIInput homePhoneValue = (UIInput) component.getAttributes().get("homePhone");
		UIInput birthCityValue = (UIInput) component.getAttributes().get("birthCity");
		UIInput birthStateValue = (UIInput) component.getAttributes().get("birthState");
		UIInput mothersMaidenNameValue = (UIInput) component.getAttributes().get("mothersMaidenName");
		UIInput addressStreetValue = (UIInput) component.getAttributes().get("addressStreet");
		UIInput addressCityValue = (UIInput) component.getAttributes().get("addressCity");
		UIInput addressStateValue = (UIInput) component.getAttributes().get("addressState");
		UIInput addressZipValue = (UIInput) component.getAttributes().get("addressZip");
		
		System.out.println("AttendedSearchValidator:  fieldValueFound():  firstNameValue         = " + firstNameValue.getValue());
		System.out.println("AttendedSearchValidator:  fieldValueFound():  middleNameValue        = " + middleNameValue.getValue());
		System.out.println("AttendedSearchValidator:  fieldValueFound():  lastNameValue          = " + lastNameValue.getValue());
		System.out.println("AttendedSearchValidator:  fieldValueFound():  genderValue            = " + genderValue.getValue());
		System.out.println("AttendedSearchValidator:  fieldValueFound():  ssnThreeValue          = " + ssnThreeValue.getValue());
		System.out.println("AttendedSearchValidator:  fieldValueFound():  ssnTwoValue            = " + ssnTwoValue.getValue());
		System.out.println("AttendedSearchValidator:  fieldValueFound():  ssnFouValue            = " + ssnFourValue.getValue());
		System.out.println("AttendedSearchValidator:  fieldValueFound():  birthDateValue         = " + birthDateValue.getValue());
		System.out.println("AttendedSearchValidator:  fieldValueFound():  homePhoneValue         = " + homePhoneValue.getValue());
		System.out.println("AttendedSearchValidator:  fieldValueFound():  birthCityValue         = " + birthCityValue.getValue());
		System.out.println("AttendedSearchValidator:  fieldValueFound():  birthStateValue        = " + birthStateValue.getValue());
		System.out.println("AttendedSearchValidator:  fieldValueFound():  mothersMaidenNameValue = " + mothersMaidenNameValue.getValue());
		System.out.println("AttendedSearchValidator:  fieldValueFound():  addressStreetValue     = " + addressStreetValue.getValue());
		System.out.println("AttendedSearchValidator:  fieldValueFound():  addressCityValue       = " + addressCityValue.getValue());
		System.out.println("AttendedSearchValidator:  fieldValueFound():  addressStateValue      = " + addressStateValue.getValue());
		System.out.println("AttendedSearchValidator:  fieldValueFound():  addressZipValue        = " + addressZipValue.getValue());
		
		// For each entry field, check for a valid value. As soon as we find one
		// that is not null and not empty, then we can stop checking.
		if (firstNameValue != null && firstNameValue.getValue() != null
				&& !((String) firstNameValue.getValue()).isEmpty()) {
			return true;
		} else if (middleNameValue != null && middleNameValue.getValue() != null
				&& !((String) middleNameValue.getValue()).isEmpty()) {
			return true;
		}
		if (lastNameValue != null && lastNameValue.getValue() != null
				&& !((String) lastNameValue.getValue()).isEmpty()) {
			return true;
		}
		if (birthDateValue != null && birthDateValue.getValue() != null) {
			return true;
		}
		if ( isGenderValid(genderValue) ) {
			return true;
		}
		if ( isSsnValid(ssnThreeValue, ssnTwoValue, ssnFourValue) ) {
			return true;
		}
		if ( isHomePhoneValid(homePhoneValue) ) {
			return true;
		}
		if (birthCityValue != null && birthCityValue.getValue() != null
				&& !((String) birthCityValue.getValue()).isEmpty()) {
			return true;
		}
		if (birthStateValue != null && birthStateValue.getValue() != null
				&& !((String) birthStateValue.getValue()).isEmpty()) {
			return true;
		}
		if (mothersMaidenNameValue != null && mothersMaidenNameValue.getValue() != null
				&& !((String) mothersMaidenNameValue.getValue()).isEmpty()) {
			return true;
		}
		if (addressStreetValue != null && addressStreetValue.getValue() != null
				&& !((String) addressStreetValue.getValue()).isEmpty()) {
			return true;
		}
		if (addressCityValue != null && addressCityValue.getValue() != null
				&& !((String) addressCityValue.getValue()).isEmpty()) {
			return true;
		}
		if (addressStateValue != null && addressStateValue.getValue() != null
				&& !((String) addressStateValue.getValue()).isEmpty()) {
			return true;
		}
		if ( isZipValid(addressZipValue) ) {
			return true;
		}
		return false;
	}
	
	private boolean isGenderValid(UIInput genderValue) {
		String genderStr = null;
		if (genderValue == null || genderValue.getValue() == null) {
			return false;
		} else {
			genderStr = (String) genderValue.getValue();
		}
		
		if ( "m".equalsIgnoreCase(genderStr) || "male".equalsIgnoreCase(genderStr) ) {
			return true;
		}
		
		if ( "f".equalsIgnoreCase(genderStr) || "female".equalsIgnoreCase(genderStr) ) {
			return true;
		}
		
		return false;
	}

	private boolean isSsnValid(UIInput ssnThreeValue, UIInput ssnTwoValue, UIInput ssnFourValue) {
		String ssn3 = null;
		String ssn2 = null;
		String ssn4 = null;

		if (ssnThreeValue == null || ssnThreeValue.getValue() == null) {
			return false;
		} else {
			ssn3 = (String) ssnThreeValue.getValue();
		}
		if (ssnTwoValue == null || ssnTwoValue.getValue() == null) {
			return false;
		} else {
			ssn2 = (String) ssnTwoValue.getValue();
		}
		if (ssnFourValue == null || ssnFourValue.getValue() == null) {
			return false;
		} else {
			ssn4 = (String) ssnFourValue.getValue();
		}
		
		ssn3 = ssn3.trim();
		ssn2 = ssn2.trim();
		ssn4 = ssn4.trim();

		if (!isNumber(ssn3) || !isNumber(ssn2) || !isNumber(ssn4)) {
			return false;
		}

		if (ssn3.length() != 3 || ssn2.length() != 2 || ssn4.length() != 4) {
			return false;
		}

		return true;
	}
	
	private boolean isHomePhoneValid(UIInput homePhoneValue) {
		String phone = null;
		if (homePhoneValue == null || homePhoneValue.getValue() == null) {
			return false;
		} else {
			phone = (String) homePhoneValue.getValue();
		}
		
		phone = phone.replaceAll("\\s|\\(|\\)|-|\\.", "");
		
		if (!isNumber(phone)) {
			return false;
		}
		return true;
	}

	private boolean isZipValid(UIInput zipValue) {
		String zip = null;
		if (zipValue == null || zipValue.getValue() == null) {
			return false;
		} else {
			zip = ((String)zipValue.getValue()).trim();
		}
				
		if (!isNumber(zip)) {
			return false;
		}
		if (zip.length() != 5) {
			return false;
		}

		return true;
	}
	
	private boolean isNumber(String numberStr) {
		if (numberStr == null || numberStr.isEmpty()) {
			return false;
		}
		Pattern p = Pattern.compile("\\d*");
		return p.matcher(numberStr).matches();
	}	
	
}
